/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.collada;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import replicatorg.app.Base;

public class ColladaParser {
    Map<String, FloatArray> floatArrayMap = new HashMap<String, FloatArray>();
    Map<String, TriangleArray> geometryMap = new HashMap<String, TriangleArray>();
    Document doc;
    TriangleArray totalGeometry = null;

    private FloatArray loadFloatArray(Element e) {
        return new FloatArray(e);
    }

    private void loadTuples(Element parent) {
        NodeList sources = parent.getElementsByTagName("source");
        int idx = 0;
        while (idx < sources.getLength()) {
            String strideStr;
            Node n = sources.item(idx);
            Element e = (Element)n;
            String id = n.getAttributes().getNamedItem("id").getNodeValue();
            NodeList arrays = e.getElementsByTagName("float_array");
            NodeList accessorNodes = e.getElementsByTagName("accessor");
            if (accessorNodes.getLength() <= 0 || (strideStr = ((Element)accessorNodes.item(0)).getAttribute("stride")) == null || Integer.parseInt(strideStr) == 3) {
                int i = 0;
                while (i < arrays.getLength()) {
                    this.floatArrayMap.put(id, this.loadFloatArray((Element)arrays.item(i)));
                    ++i;
                }
            }
            ++idx;
        }
    }

    Map<String, FloatArray> loadVertices(Element e) {
        NodeList inputList = e.getElementsByTagName("input");
        HashMap<String, FloatArray> verticesMap = new HashMap<String, FloatArray>();
        int j = 0;
        while (j < inputList.getLength()) {
            Element inputElement = (Element)inputList.item(j);
            String sourceRef = inputElement.getAttribute("source");
            String sourceId = sourceRef.substring(1);
            FloatArray points = this.floatArrayMap.get(sourceId);
            String semantic = inputElement.getAttribute("semantic");
            String offset = inputElement.getAttribute("offset");
            if (offset != null && offset.length() != 0) {
                points.setOffset(Integer.parseInt(offset));
            }
            verticesMap.put(semantic.toLowerCase(), points);
            ++j;
        }
        return verticesMap;
    }

    private void loadGeometries() {
        NodeList geometries = this.doc.getElementsByTagName("geometry");
        int idx = 0;
        while (idx < geometries.getLength()) {
            Element e = (Element)geometries.item(idx);
            this.loadTuples(e);
            String id = e.getAttribute("id");
            NodeList verticesList = e.getElementsByTagName("vertices");
            Map<String, FloatArray> verticesMap = this.loadVertices((Element)verticesList.item(0));
            FloatArray positions = verticesMap.get("position");
            FloatArray normals = verticesMap.get("normal");
            NodeList trianglesList = e.getElementsByTagName("triangles");
            Element trianglesElement = (Element)trianglesList.item(0);
            int vertexCount = Integer.parseInt(trianglesElement.getAttribute("count")) * 3;
            TriangleArray tris = new TriangleArray(vertexCount, 3);
            String[] vertexIndices = trianglesElement.getTextContent().trim().split("\\s+");
            int stride = vertexIndices.length / vertexCount;
            int i = 0;
            while (i < vertexCount) {
                int vertRefIdx = i * stride;
                int vertIdx = Integer.parseInt(vertexIndices[vertRefIdx + positions.getOffset()]);
                tris.setCoordinate(i, positions.getPoint(vertIdx * 3));
                if (normals != null) {
                    int normIdx = Integer.parseInt(vertexIndices[vertRefIdx + normals.getOffset()]);
                    tris.setNormal(i, normals.getVector(normIdx * 3));
                }
                ++i;
            }
            this.geometryMap.put(id, tris);
            ++idx;
        }
    }

    private void addGeometry(TriangleArray g) {
        if (this.totalGeometry == null) {
            this.totalGeometry = g;
        } else if (g != null) {
            int vc = g.getVertexCount() + this.totalGeometry.getVertexCount();
            TriangleArray newG = new TriangleArray(vc, 3);
            Point3d v = new Point3d();
            Vector3f n = new Vector3f();
            int gvc = g.getVertexCount();
            int i = 0;
            while (i < gvc) {
                g.getCoordinate(i, v);
                g.getNormal(i, n);
                newG.setCoordinate(i, v);
                newG.setNormal(i, n);
                ++i;
            }
            i = 0;
            while (i < this.totalGeometry.getVertexCount()) {
                this.totalGeometry.getCoordinate(i, v);
                this.totalGeometry.getNormal(i, n);
                newG.setCoordinate(gvc + i, v);
                newG.setNormal(gvc + i, n);
                ++i;
            }
            this.totalGeometry = newG;
        }
    }

    public TriangleArray getTotalGeometry() {
        return this.totalGeometry;
    }

    public boolean parse(InputSource is) {
        this.totalGeometry = null;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = db.parse(is);
            this.loadGeometries();
            NodeList instances = this.doc.getElementsByTagName("instance_geometry");
            int idx = 0;
            while (idx < instances.getLength()) {
                Node n = instances.item(idx);
                String u = n.getAttributes().getNamedItem("url").getNodeValue();
                TriangleArray geometry = this.geometryMap.get(u.substring(1));
                this.addGeometry(geometry);
                ++idx;
            }
            return true;
        }
        catch (ParserConfigurationException e) {
            Base.logger.log(Level.SEVERE, "Could not configure parser", e);
        }
        catch (SAXException e) {
            Base.logger.log(Level.INFO, "Could not configure parser", e);
        }
        catch (IOException e) {
            Base.logger.log(Level.SEVERE, "IO Error during Collada document read", e);
        }
        return false;
    }

    class FloatArray {
        private double[] data;
        private int offset = 0;
        private int stride = 3;

        public double get(int idx) {
            return this.data[idx];
        }

        public int getOffset() {
            return this.offset;
        }

        public int getCount() {
            return this.data.length;
        }

        public int getStride() {
            return this.stride;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public FloatArray(Element e) {
            String strideStr;
            int count = Integer.parseInt(e.getAttribute("count"));
            this.data = new double[count];
            String[] values = e.getTextContent().trim().split("\\s+");
            assert (values.length == this.data.length);
            int i = 0;
            while (i < this.data.length) {
                this.data[i] = Double.parseDouble(values[i]);
                ++i;
            }
            NodeList accessorNodes = e.getElementsByTagName("accessor");
            if (accessorNodes.getLength() > 0 && (strideStr = ((Element)accessorNodes.item(0)).getAttribute("stride")) != null) {
                this.stride = Integer.parseInt(strideStr);
            }
        }

        public Vector3f getVector(int idx) {
            return new Vector3f((float)this.data[idx], (float)this.data[idx + 1], (float)this.data[idx + 2]);
        }

        public Point3d getPoint(int idx) {
            return new Point3d(this.data[idx], this.data[idx + 1], this.data[idx + 2]);
        }
    }
}

